
package net.lightapi.portal.config.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * update a config
 */
@ServiceHandler(id="lightapi.net/config/updateConfig/0.1.0")
public class UpdateConfig extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateConfig.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.CONFIG_UPDATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_CONFIG;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the configId in the data section.
        return (String) map.get("configId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
