
package net.lightapi.portal.config.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * update config instance file command handler.
*/
@ServiceHandler(id="lightapi.net/config/deleteConfigInstanceFile/0.1.0")
public class DeleteConfigInstanceFile extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteConfigInstanceFile.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.CONFIG_INSTANCE_FILE_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_INSTANCE_FILE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the instanceFileId in the data section.
        return (String) map.get("instanceFileId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
