
package net.lightapi.portal.config.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * delete a config instance app
*/
@ServiceHandler(id="lightapi.net/config/deleteConfigInstanceApp/0.1.0")
public class DeleteConfigInstanceApp extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteConfigInstanceApp.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.CONFIG_INSTANCE_APP_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_CONFIG_PROPERTY;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the propertyId in the data section.
        return (String) map.get("propertyId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
