
package net.lightapi.portal.config.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * delete a config environment
 */
@ServiceHandler(id="lightapi.net/config/deleteConfigEnvironment/0.1.0")
public class DeleteConfigEnvironment extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteConfigEnvironment.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.CONFIG_ENVIRONMENT_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_CONFIG_PROPERTY;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the propertyId in the data section.
        return (String) map.get("propertyId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
