
package net.lightapi.portal.config.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * create a new config property
 */
@ServiceHandler(id="lightapi.net/config/createConfigProperty/0.1.0")
public class CreateConfigProperty extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateConfigProperty.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.CONFIG_PROPERTY_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_CONFIG_PROPERTY;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the propertyId in the data section.
        return (String) map.get("propertyId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("propertyId", UuidUtil.getUUID());
        return Success.of(map);
    }
}
