
package net.lightapi.portal.config.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.Util;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * create a new config
*/
@ServiceHandler(id="lightapi.net/config/createConfig/0.1.0")
public class CreateConfig extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateConfig.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.CONFIG_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_CONFIG;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the configId in the data section.
        return (String) map.get("configId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("configId", UuidUtil.getUUID());
        return Success.of(map);
    }

}
