
package net.lightapi.portal.client.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * create a new app. This is called from the light-portal from the app admin.
 */

@ServiceHandler(id="lightapi.net/client/createApp/0.1.0")
public class CreateApp extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateApp.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.APP_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_APP;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the appId in the data section.
        return (String) map.get("appId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
