
package net.lightapi.portal.client.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * update a new app. This is called from the light-portal from the app admin.
 */
@ServiceHandler(id="lightapi.net/client/updateApp/0.1.0")
public class UpdateApp extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateApp.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.APP_UPDATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
