
package net.lightapi.portal.category.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Delete a category for an entity
*/
@ServiceHandler(id="lightapi.net/category/deleteCategory/0.1.0")
public class DeleteCategory extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteCategory.class);
    @Override
    protected String getCloudEventType() {
        return PortalConstants.CATEGORY_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_CATEGORY;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the categoryId in the data section.
        return (String) map.get("categoryId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
