
package net.lightapi.portal.category.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.Util;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * create a new category for an entity
*/
@ServiceHandler(id="lightapi.net/category/createCategory/0.1.0")
public class CreateCategory extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateCategory.class);
    @Override
    protected String getCloudEventType() {
        return PortalConstants.CATEGORY_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_CATEGORY;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the categoryId in the data section.
        return (String) map.get("categoryId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("categoryId", UuidUtil.getUUID());
        return Success.of(map);
    }

}

