
package net.lightapi.portal.attribute.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Update attribute column filter for host
*/
@ServiceHandler(id="lightapi.net/attribute/updateAttributeColFilter/0.1.0")
public class UpdateAttributeColFilter extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateAttributeColFilter.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.ATTRIBUTE_COL_FILTER_UPDATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_ATTRIBUTE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the attributeId in the data section.
        return (String) map.get("attributeId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
