
package net.lightapi.portal.attribute.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Delete an attribute user for the host.
*/
@ServiceHandler(id="lightapi.net/attribute/deleteAttributeUser/0.1.0")
public class DeleteAttributeUser extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteAttributeUser.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.ATTRIBUTE_USER_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_ATTRIBUTE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the attributeId in the data section.
        return (String) map.get("attributeId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
