/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.recipes.impl.v1_7.impl;

import java.util.List;
import net.lenni0451.mcstructs.items.ItemRegistry;
import net.lenni0451.mcstructs.items.info.ItemType;
import net.lenni0451.mcstructs.items.stacks.LegacyItemStack;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.recipes.ICraftingInventory;
import net.lenni0451.mcstructs.recipes.ICraftingRecipe;

public class FireworksCraftingRecipe_v1_7<I>
implements ICraftingRecipe<I, LegacyItemStack<I>> {
    private static final int[] DYE_COLORS = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 0xABABAB, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    @Override
    public boolean matches(ItemRegistry<I, LegacyItemStack<I>> itemRegistry, ICraftingInventory<I, LegacyItemStack<I>> craftingInventory) {
        return this.getResult(itemRegistry, craftingInventory) != null;
    }

    @Override
    public LegacyItemStack<I> getResult(ItemRegistry<I, LegacyItemStack<I>> itemRegistry, ICraftingInventory<I, LegacyItemStack<I>> craftingInventory) {
        int paper = 0;
        int flyDuration = 0;
        int colors = 0;
        int fireworkStars = 0;
        int effects = 0;
        int shapes = 0;
        for (int i = 0; i < craftingInventory.getSize(); ++i) {
            LegacyItemStack<I> stack = craftingInventory.getStack(i);
            if (stack == null) continue;
            List types = stack.getMeta().getTypes();
            if (types.contains(ItemType.GUNPOWDER)) {
                ++flyDuration;
                continue;
            }
            if (types.contains(ItemType.FIREWORK_STAR)) {
                ++fireworkStars;
                continue;
            }
            if (types.contains(ItemType.DYE)) {
                ++colors;
                continue;
            }
            if (types.contains(ItemType.PAPER)) {
                ++paper;
                continue;
            }
            if (types.contains(ItemType.GLOWSTONE_DUST)) {
                ++effects;
                continue;
            }
            if (types.contains(ItemType.DIAMOND)) {
                ++effects;
                continue;
            }
            if (types.contains(ItemType.FIRE_CHARGE)) {
                ++shapes;
                continue;
            }
            if (types.contains(ItemType.FEATHER)) {
                ++shapes;
                continue;
            }
            if (types.contains(ItemType.GOLD_NUGGET)) {
                ++shapes;
                continue;
            }
            if (types.contains(ItemType.SKULL)) {
                ++shapes;
                continue;
            }
            return null;
        }
        effects += colors + shapes;
        if (flyDuration > 3 || paper > 1) {
            return null;
        }
        LegacyItemStack result = null;
        if (flyDuration >= 1 && paper == 1 && effects == 0) {
            result = (LegacyItemStack)itemRegistry.create(itemRegistry.requireByType(ItemType.FIREWORK_ROCKET));
            if (fireworkStars > 0) {
                ListTag explosions = new ListTag(NbtType.COMPOUND);
                for (int i = 0; i < craftingInventory.getSize(); ++i) {
                    LegacyItemStack<I> stack = craftingInventory.getStack(i);
                    if (stack == null || !stack.getMeta().getTypes().contains(ItemType.FIREWORK_STAR) || !stack.hasTag() || !stack.getTag().contains("Explosion", NbtType.COMPOUND)) continue;
                    explosions.add((INbtTag)stack.getTag().getCompound("Explosion"));
                }
                CompoundTag fireworks = new CompoundTag();
                fireworks.add("Explosions", (INbtTag)explosions);
                fireworks.addByte("Flight", (byte)flyDuration);
                result.getOrCreateTag().add("Fireworks", (INbtTag)fireworks);
            }
        } else if (flyDuration == 1 && paper == 0 && fireworkStars == 0 && colors > 0 && shapes <= 1) {
            result = (LegacyItemStack)itemRegistry.create(itemRegistry.requireByType(ItemType.FIREWORK_STAR));
            ListTag colorsTag = new ListTag(NbtType.INT);
            CompoundTag explosion = new CompoundTag();
            int type = 0;
            for (int i = 0; i < craftingInventory.getSize(); ++i) {
                LegacyItemStack<I> stack = craftingInventory.getStack(i);
                if (stack == null) continue;
                List types = stack.getMeta().getTypes();
                if (types.contains(ItemType.DYE)) {
                    colorsTag.add((INbtTag)new IntTag(DYE_COLORS[stack.getDamage()]));
                    continue;
                }
                if (types.contains(ItemType.GLOWSTONE_DUST)) {
                    explosion.addByte("Flicker", (byte)1);
                    continue;
                }
                if (types.contains(ItemType.DIAMOND)) {
                    explosion.addByte("Trail", (byte)1);
                    continue;
                }
                if (types.contains(ItemType.FIRE_CHARGE)) {
                    type = 1;
                    continue;
                }
                if (types.contains(ItemType.GOLD_NUGGET)) {
                    type = 2;
                    continue;
                }
                if (types.contains(ItemType.SKULL)) {
                    type = 3;
                    continue;
                }
                if (!types.contains(ItemType.FEATHER)) continue;
                type = 4;
            }
            explosion.add("Colors", (INbtTag)new IntArrayTag(colorsTag));
            explosion.addByte("Type", (byte)type);
            result.getOrCreateTag().add("Explosion", (INbtTag)explosion);
        } else if (flyDuration == 0 && paper == 0 && fireworkStars == 1 && colors > 0 && colors == effects) {
            ListTag fadeColorsTag = new ListTag(NbtType.INT);
            for (int i = 0; i < craftingInventory.getSize(); ++i) {
                LegacyItemStack<I> stack = craftingInventory.getStack(i);
                if (stack == null) continue;
                if (stack.getMeta().getTypes().contains(ItemType.DYE)) {
                    fadeColorsTag.add((INbtTag)new IntTag(DYE_COLORS[stack.getDamage()]));
                    continue;
                }
                if (!stack.getMeta().getTypes().contains(ItemType.FIREWORK_STAR)) continue;
                result = (LegacyItemStack)stack.copy();
                result.setCount(1);
            }
            if (result == null || !result.hasTag()) {
                return null;
            }
            CompoundTag explosion = result.getTag().getCompound("Explosion");
            explosion.add("FadeColors", (INbtTag)new IntArrayTag(fadeColorsTag));
        }
        return result;
    }
}

