/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.recipes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.lenni0451.mcstructs.items.AItemStack;
import net.lenni0451.mcstructs.items.ItemRegistry;
import net.lenni0451.mcstructs.recipes.ICraftingInventory;
import net.lenni0451.mcstructs.recipes.ICraftingRecipe;
import net.lenni0451.mcstructs.recipes.VillagerRecipe;

public abstract class ARecipeRegistry<I, S extends AItemStack<I, S>> {
    private final ItemRegistry<I, S> itemRegistry;
    private final List<ICraftingRecipe<I, S>> craftingRecipes;
    private final Map<S, S> furnaceRecipes;
    private final List<VillagerRecipe<I, S>> villagerRecipes;

    public ARecipeRegistry(ItemRegistry<I, S> itemRegistry) {
        this.itemRegistry = itemRegistry;
        this.craftingRecipes = new ArrayList<ICraftingRecipe<I, S>>();
        this.furnaceRecipes = new HashMap<S, S>();
        this.villagerRecipes = new ArrayList<VillagerRecipe<I, S>>();
    }

    public ItemRegistry<I, S> getItemRegistry() {
        return this.itemRegistry;
    }

    public List<ICraftingRecipe<I, S>> getCraftingRecipes() {
        return this.craftingRecipes;
    }

    public Map<S, S> getFurnaceRecipes() {
        return this.furnaceRecipes;
    }

    public List<VillagerRecipe<I, S>> getVillagerRecipes() {
        return this.villagerRecipes;
    }

    public void registerCraftingRecipe(ICraftingRecipe<I, S> recipe) {
        this.craftingRecipes.add(recipe);
    }

    public void registerFurnaceRecipe(S input, S output) {
        this.furnaceRecipes.put(input, output);
    }

    public void registerVillagerRecipe(S input1, @Nullable S input2, S output) {
        this.registerVillagerRecipe(input1, input2, output, true);
    }

    public void registerVillagerRecipe(S input1, S input2, S output, boolean enabled) {
        this.villagerRecipes.add(new VillagerRecipe(input1, input2, output, enabled));
    }

    @Nullable
    public abstract S findCraftingRecipe(ICraftingInventory<I, S> var1);

    public abstract S findFurnaceRecipe(S var1);
}

