/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.recipes.impl.v1_7.impl;

import java.util.ArrayList;
import java.util.List;
import net.lenni0451.mcstructs.items.ItemRegistry;
import net.lenni0451.mcstructs.items.info.ItemTag;
import net.lenni0451.mcstructs.items.info.ItemType;
import net.lenni0451.mcstructs.items.stacks.LegacyItemStack;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.recipes.ICraftingInventory;
import net.lenni0451.mcstructs.recipes.ICraftingRecipe;

public class ArmorColorCraftingRecipe_v1_7<I>
implements ICraftingRecipe<I, LegacyItemStack<I>> {
    private static final int[][] DYE_COLOR = new int[][]{{25, 25, 25}, {153, 51, 51}, {102, 127, 51}, {102, 76, 51}, {51, 76, 178}, {127, 63, 178}, {76, 127, 153}, {153, 153, 153}, {76, 76, 76}, {242, 127, 165}, {127, 204, 25}, {229, 229, 51}, {102, 153, 216}, {178, 76, 216}, {216, 127, 51}, {255, 255, 255}};

    @Override
    public boolean matches(ItemRegistry<I, LegacyItemStack<I>> itemRegistry, ICraftingInventory<I, LegacyItemStack<I>> craftingInventory) {
        LegacyItemStack<I> armorStack = null;
        ArrayList<Object> colors = new ArrayList<Object>();
        for (int i = 0; i < craftingInventory.getSize(); ++i) {
            LegacyItemStack<I> stack = craftingInventory.getStack(i);
            if (stack == null) continue;
            if (ItemType.isArmor((List)stack.getMeta().getTypes())) {
                if (armorStack != null) {
                    return false;
                }
                if (!stack.getMeta().getTags().contains(ItemTag.MATERIAL_LEATHER)) {
                    return false;
                }
                armorStack = stack;
                continue;
            }
            if (stack.getMeta().getTypes().contains(ItemType.DYE)) {
                colors.add(stack.getItem());
                continue;
            }
            return false;
        }
        return armorStack != null && !colors.isEmpty();
    }

    @Override
    public LegacyItemStack<I> getResult(ItemRegistry<I, LegacyItemStack<I>> itemRegistry, ICraftingInventory<I, LegacyItemStack<I>> craftingInventory) {
        LegacyItemStack armorStack = null;
        int[] armorColor = new int[3];
        int darkness = 0;
        int colorCount = 0;
        for (int i = 0; i < craftingInventory.getSize(); ++i) {
            LegacyItemStack<I> stack = craftingInventory.getStack(i);
            if (stack == null) continue;
            if (ItemType.isArmor((List)stack.getMeta().getTypes())) {
                if (armorStack != null) {
                    return null;
                }
                if (!stack.getMeta().getTags().contains(ItemTag.MATERIAL_LEATHER)) {
                    return null;
                }
                armorStack = (LegacyItemStack)stack.copy();
                armorStack.setCount(1);
                if (!this.hasColor(armorStack)) continue;
                int color = this.getColor(armorStack);
                float r = color >> 16 & 0xFF;
                float g = color >> 8 & 0xFF;
                float b = color & 0xFF;
                darkness = (int)((float)darkness + Math.max(r, Math.max(g, b)));
                armorColor[0] = (int)((float)armorColor[0] + r * 255.0f);
                armorColor[1] = (int)((float)armorColor[1] + g * 255.0f);
                armorColor[2] = (int)((float)armorColor[2] + b * 255.0f);
                ++colorCount;
                continue;
            }
            if (stack.getMeta().getTypes().contains(ItemType.DYE)) {
                int[] color = DYE_COLOR[stack.getDamage() & 0xF];
                int r = color[0];
                int g = color[1];
                int b = color[2];
                darkness += Math.max(r, Math.max(g, b));
                armorColor[0] = armorColor[0] + r;
                armorColor[1] = armorColor[1] + g;
                armorColor[2] = armorColor[2] + b;
                ++colorCount;
                continue;
            }
            return null;
        }
        if (armorStack == null) {
            return null;
        }
        int r = armorColor[0] / colorCount;
        int g = armorColor[1] / colorCount;
        int b = armorColor[2] / colorCount;
        float brightness = (float)darkness / (float)colorCount;
        float endBrightness = Math.max(r, Math.max(g, b));
        r = (int)((float)r * brightness / endBrightness);
        g = (int)((float)g * brightness / endBrightness);
        b = (int)((float)b * brightness / endBrightness);
        this.setColor(armorStack, r << 16 | g << 8 | b);
        return armorStack;
    }

    private boolean hasColor(LegacyItemStack<I> stack) {
        if (!ItemType.isArmor((List)stack.getMeta().getTypes())) {
            return false;
        }
        if (!stack.getMeta().getTags().contains(ItemTag.MATERIAL_LEATHER)) {
            return false;
        }
        if (!stack.hasTag()) {
            return false;
        }
        if (!stack.getTag().contains("display", NbtType.COMPOUND)) {
            return false;
        }
        return stack.getTag().getCompound("display").contains("color", NbtType.INT);
    }

    private int getColor(LegacyItemStack<I> stack) {
        if (!ItemType.isArmor((List)stack.getMeta().getTypes())) {
            return -1;
        }
        if (!stack.getMeta().getTags().contains(ItemTag.MATERIAL_LEATHER)) {
            return -1;
        }
        CompoundTag tag = stack.getTag();
        if (tag == null) {
            return 10511680;
        }
        CompoundTag display = tag.getCompound("display");
        if (display == null) {
            return 10511680;
        }
        if (!display.contains("color", NbtType.INT)) {
            return 10511680;
        }
        return display.getInt("color");
    }

    private void setColor(LegacyItemStack<I> stack, int color) {
        if (!ItemType.isArmor((List)stack.getMeta().getTypes()) || !stack.getMeta().getTags().contains(ItemTag.MATERIAL_LEATHER)) {
            throw new IllegalArgumentException("The given stack is not a leather armor");
        }
        CompoundTag tag = stack.getOrCreateTag();
        if (!tag.contains("display", NbtType.COMPOUND)) {
            tag.add("display", (INbtTag)new CompoundTag());
        }
        CompoundTag display = tag.getCompound("display");
        display.addInt("color", color);
    }
}

