/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs.recipes.impl.v1_7;

import java.util.Map;
import java.util.function.Function;
import net.lenni0451.mcstructs.items.ItemRegistry;
import net.lenni0451.mcstructs.items.info.ItemTag;
import net.lenni0451.mcstructs.items.stacks.LegacyItemStack;
import net.lenni0451.mcstructs.recipes.ARecipeRegistry;
import net.lenni0451.mcstructs.recipes.ICraftingInventory;
import net.lenni0451.mcstructs.recipes.ICraftingRecipe;
import net.lenni0451.mcstructs.recipes.impl.v1_7.impl.ArmorColorCraftingRecipe_v1_7;
import net.lenni0451.mcstructs.recipes.impl.v1_7.impl.BookCopyCraftingRecipe_v1_7;
import net.lenni0451.mcstructs.recipes.impl.v1_7.impl.ExtendMapCraftingRecipe_v1_7;
import net.lenni0451.mcstructs.recipes.impl.v1_7.impl.FireworksCraftingRecipe_v1_7;
import net.lenni0451.mcstructs.recipes.impl.v1_7.impl.MapCopyCraftingRecipe_v1_7;

public class RecipeRegistry_v1_7<I>
extends ARecipeRegistry<I, LegacyItemStack<I>> {
    public RecipeRegistry_v1_7(ItemRegistry<I, LegacyItemStack<I>> itemRegistry) {
        this(itemRegistry, stack -> 0);
    }

    public RecipeRegistry_v1_7(ItemRegistry<I, LegacyItemStack<I>> itemRegistry, Function<LegacyItemStack<I>, Integer> mapScaleProvider) {
        super(itemRegistry);
        this.registerCraftingRecipe(new ArmorColorCraftingRecipe_v1_7());
        this.registerCraftingRecipe(new BookCopyCraftingRecipe_v1_7());
        this.registerCraftingRecipe(new MapCopyCraftingRecipe_v1_7());
        this.registerCraftingRecipe(new ExtendMapCraftingRecipe_v1_7<I>(itemRegistry, mapScaleProvider));
        this.registerCraftingRecipe(new FireworksCraftingRecipe_v1_7());
    }

    @Override
    public LegacyItemStack<I> findCraftingRecipe(ICraftingInventory<I, LegacyItemStack<I>> craftingInventory) {
        LegacyItemStack<I> stack1 = null;
        LegacyItemStack<I> stack2 = null;
        int stackCount = 0;
        for (int i = 0; i < craftingInventory.getSize(); ++i) {
            LegacyItemStack<I> legacyItemStack = craftingInventory.getStack(i);
            if (legacyItemStack == null) continue;
            if (stackCount == 0) {
                stack1 = legacyItemStack;
            } else if (stackCount == 1) {
                stack2 = legacyItemStack;
            }
            ++stackCount;
        }
        if (stackCount == 2 && stack1.getItem().equals(stack2.getItem()) && stack1.getCount() == 1 && stack2.getCount() == 1 && stack1.getMeta().getTags().contains(ItemTag.DAMAGEABLE)) {
            int damage1 = stack1.getMeta().getMaxDamage() - stack1.getDamage();
            int n = stack2.getMeta().getMaxDamage() - stack2.getDamage();
            int totalDamage = damage1 + n + stack1.getMeta().getMaxDamage() * 5 / 100;
            int newDamage = Math.max(0, stack1.getMeta().getMaxDamage() - totalDamage);
            return (LegacyItemStack)this.getItemRegistry().create(stack1.getItem(), 1, newDamage);
        }
        for (ICraftingRecipe iCraftingRecipe : this.getCraftingRecipes()) {
            if (!iCraftingRecipe.matches(this.getItemRegistry(), craftingInventory)) continue;
            return iCraftingRecipe.getResult(this.getItemRegistry(), craftingInventory);
        }
        return null;
    }

    @Override
    public LegacyItemStack<I> findFurnaceRecipe(LegacyItemStack<I> input) {
        for (Map.Entry entry : this.getFurnaceRecipes().entrySet()) {
            if (!((LegacyItemStack)entry.getKey()).getItem().equals(input.getItem()) || ((LegacyItemStack)entry.getKey()).getDamage() != Short.MAX_VALUE && ((LegacyItemStack)entry.getKey()).getDamage() != input.getDamage()) continue;
            return (LegacyItemStack)entry.getValue();
        }
        return null;
    }
}

