/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.nbt.io.impl;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.exceptions.NbtReadException;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.NbtReadTracker;
import net.lenni0451.mcstructs.nbt.io.types.INbtReader;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;
import net.lenni0451.mcstructs_bedrock.nbt.io.impl.BedrockReadTypes;

@ParametersAreNonnullByDefault
public class BedrockNbtReader
implements INbtReader {
    @Nonnull
    public NbtType readType(DataInput in, NbtReadTracker readTracker) throws IOException {
        byte id = in.readByte();
        NbtType type = NbtType.byId((int)id);
        if (type == null || type.equals((Object)NbtType.LONG_ARRAY)) {
            throw new IOException("Unknown Nbt type: " + id);
        }
        return type;
    }

    @Nonnull
    public NbtHeader readHeader(DataInput in, NbtReadTracker readTracker) throws IOException {
        NbtType type = this.readType(in, readTracker);
        if (NbtType.END.equals((Object)type)) {
            return NbtHeader.END;
        }
        return new NbtHeader(type, BedrockReadTypes.readString(in));
    }

    @Nonnull
    public ByteTag readByte(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(9);
        return new ByteTag(in.readByte());
    }

    @Nonnull
    public ShortTag readShort(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(10);
        return new ShortTag(in.readShort());
    }

    @Nonnull
    public IntTag readInt(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(12);
        return new IntTag(BedrockReadTypes.readVarInt(in));
    }

    @Nonnull
    public LongTag readLong(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(16);
        return new LongTag(BedrockReadTypes.readVarLong(in));
    }

    @Nonnull
    public FloatTag readFloat(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(12);
        return new FloatTag(in.readFloat());
    }

    @Nonnull
    public DoubleTag readDouble(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(16);
        return new DoubleTag(in.readDouble());
    }

    @Nonnull
    public ByteArrayTag readByteArray(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(24);
        int length = BedrockReadTypes.readVarInt(in);
        readTracker.read(length);
        byte[] value = new byte[length];
        in.readFully(value);
        return new ByteArrayTag(value);
    }

    @Nonnull
    public StringTag readString(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(36);
        String value = BedrockReadTypes.readString(in);
        readTracker.read(2 * value.length());
        return new StringTag(value);
    }

    @Nonnull
    public ListTag<?> readList(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(37);
        NbtType type = this.readType(in, readTracker);
        int count = BedrockReadTypes.readVarInt(in);
        if (type == NbtType.END && count > 0) {
            throw new NbtReadException("ListTag with type END and count > 0");
        }
        if (count < 0) {
            throw new NbtReadException("ListTag with negative count");
        }
        readTracker.read(4 * count);
        ArrayList<INbtTag> value = new ArrayList<INbtTag>(Math.min(count, 512));
        for (int i = 0; i < count; ++i) {
            readTracker.pushDepth();
            INbtTag tag = this.read(type, in, readTracker);
            readTracker.popDepth();
            value.add(tag);
        }
        return new ListTag(type, value);
    }

    @Nonnull
    public CompoundTag readCompound(DataInput in, NbtReadTracker readTracker) throws IOException {
        NbtHeader header;
        readTracker.read(48);
        HashMap<String, INbtTag> value = new HashMap<String, INbtTag>();
        while (!(header = this.readHeader(in, readTracker)).isEnd()) {
            readTracker.read(28 + 2 * header.getName().length());
            readTracker.pushDepth();
            INbtTag tag = this.read(header.getType(), in, readTracker);
            readTracker.popDepth();
            if (value.put(header.getName(), tag) == null) continue;
            readTracker.read(36);
        }
        return new CompoundTag(value);
    }

    @Nonnull
    public IntArrayTag readIntArray(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(24);
        int length = BedrockReadTypes.readVarInt(in);
        readTracker.read(4 * length);
        int[] value = new int[length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = BedrockReadTypes.readVarInt(in);
        }
        return new IntArrayTag(value);
    }

    @Nonnull
    public LongArrayTag readLongArray(DataInput in, NbtReadTracker readTracker) {
        throw new UnsupportedOperationException("LongArrayTag is not supported in Bedrock Nbt");
    }
}

