/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.nbt.io.impl;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BedrockWriteTypes {
    public static void writeVarInt(DataOutput out, int value) throws IOException {
        BedrockWriteTypes.writeUnsignedVarLong(out, (long)value << 1 ^ (long)(value >> 31));
    }

    public static void writeUnsignedVarInt(DataOutput out, int value) throws IOException {
        BedrockWriteTypes.writeUnsignedVarLong(out, (long)value & 0xFFFFFFFFL);
    }

    public static void writeVarLong(DataOutput out, long value) throws IOException {
        BedrockWriteTypes.writeUnsignedVarLong(out, value << 1 ^ value >> 63);
    }

    public static void writeUnsignedVarLong(DataOutput out, long value) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)(value & 0x7FL) | 0x80);
            value >>>= 7;
        }
        out.writeByte((int)value);
    }

    public static void writeByteArray(DataOutput out, byte[] bytes) throws IOException {
        BedrockWriteTypes.writeUnsignedVarInt(out, bytes.length);
        out.write(bytes);
    }

    public static void writeString(DataOutput out, String string) throws IOException {
        BedrockWriteTypes.writeByteArray(out, string.getBytes(StandardCharsets.UTF_8));
    }
}

