/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.nbt.io.impl;

import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

class BedrockReadTypes {
    BedrockReadTypes() {
    }

    public static int readVarInt(DataInput in) throws IOException {
        int i = BedrockReadTypes.readUnsignedVarInt(in);
        return i >>> 1 ^ -(i & 1);
    }

    public static int readUnsignedVarInt(DataInput in) throws IOException {
        return (int)BedrockReadTypes.readUnsignedVarLong(in);
    }

    public static long readVarLong(DataInput in) throws IOException {
        long i = BedrockReadTypes.readUnsignedVarLong(in);
        return i >>> 1 ^ -(i & 1L);
    }

    public static long readUnsignedVarLong(DataInput in) throws IOException {
        byte b;
        long value = 0L;
        int size = 0;
        do {
            b = in.readByte();
            value |= (long)(b & 0x7F) << size++ * 7;
            if (size <= 10) continue;
            throw new IOException("VarLong is too big");
        } while ((b & 0x80) != 0);
        return value;
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        int length = BedrockReadTypes.readUnsignedVarInt(in);
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return bytes;
    }

    public static String readString(DataInput in) throws IOException {
        return new String(BedrockReadTypes.readByteArray(in), StandardCharsets.UTF_8);
    }
}

