/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.nbt.io.impl;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.types.INbtWriter;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;
import net.lenni0451.mcstructs_bedrock.nbt.io.impl.BedrockWriteTypes;

public class BedrockNbtWriter
implements INbtWriter {
    public void writeHeader(DataOutput out, NbtHeader header) throws IOException {
        if (header.isEnd()) {
            out.writeByte(NbtType.END.getId());
        } else {
            out.writeByte(header.getType().getId());
            BedrockWriteTypes.writeString(out, header.getName());
        }
    }

    public void writeByte(DataOutput out, ByteTag tag) throws IOException {
        out.writeByte(tag.getValue());
    }

    public void writeShort(DataOutput out, ShortTag tag) throws IOException {
        out.writeShort(tag.getValue());
    }

    public void writeInt(DataOutput out, IntTag value) throws IOException {
        BedrockWriteTypes.writeVarInt(out, value.getValue());
    }

    public void writeLong(DataOutput out, LongTag value) throws IOException {
        BedrockWriteTypes.writeVarLong(out, value.getValue());
    }

    public void writeFloat(DataOutput out, FloatTag value) throws IOException {
        out.writeFloat(value.getValue());
    }

    public void writeDouble(DataOutput out, DoubleTag value) throws IOException {
        out.writeDouble(value.getValue());
    }

    public void writeByteArray(DataOutput out, ByteArrayTag value) throws IOException {
        BedrockWriteTypes.writeVarInt(out, value.getLength());
        out.write(value.getValue());
    }

    public void writeString(DataOutput out, StringTag value) throws IOException {
        BedrockWriteTypes.writeString(out, value.getValue());
    }

    public void writeList(DataOutput out, ListTag<?> value) throws IOException {
        if (value.getType() == null) {
            out.writeByte(NbtType.END.getId());
        } else {
            out.writeByte(value.getType().getId());
        }
        BedrockWriteTypes.writeVarInt(out, value.size());
        for (INbtTag tag : value.getValue()) {
            this.write(out, tag);
        }
    }

    public void writeCompound(DataOutput out, CompoundTag value) throws IOException {
        for (Map.Entry entry : value.getValue().entrySet()) {
            this.writeHeader(out, new NbtHeader(((INbtTag)entry.getValue()).getNbtType(), (String)entry.getKey()));
            this.write(out, (INbtTag)entry.getValue());
        }
        this.writeHeader(out, NbtHeader.END);
    }

    public void writeIntArray(DataOutput out, IntArrayTag value) throws IOException {
        BedrockWriteTypes.writeVarInt(out, value.getLength());
        for (int i : value.getValue()) {
            BedrockWriteTypes.writeVarInt(out, i);
        }
    }

    public void writeLongArray(DataOutput out, LongArrayTag value) throws IOException {
        BedrockWriteTypes.writeVarInt(out, value.getLength());
        for (long l : value.getValue()) {
            out.writeLong(l);
        }
    }
}

