/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.mcstructs_bedrock.nbt.io.impl;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.lenni0451.mcstructs.nbt.INbtTag;
import net.lenni0451.mcstructs.nbt.NbtType;
import net.lenni0451.mcstructs.nbt.exceptions.NbtReadException;
import net.lenni0451.mcstructs.nbt.io.NbtHeader;
import net.lenni0451.mcstructs.nbt.io.NbtReadTracker;
import net.lenni0451.mcstructs.nbt.io.types.INbtReader;
import net.lenni0451.mcstructs.nbt.tags.ByteArrayTag;
import net.lenni0451.mcstructs.nbt.tags.ByteTag;
import net.lenni0451.mcstructs.nbt.tags.CompoundTag;
import net.lenni0451.mcstructs.nbt.tags.DoubleTag;
import net.lenni0451.mcstructs.nbt.tags.FloatTag;
import net.lenni0451.mcstructs.nbt.tags.IntArrayTag;
import net.lenni0451.mcstructs.nbt.tags.IntTag;
import net.lenni0451.mcstructs.nbt.tags.ListTag;
import net.lenni0451.mcstructs.nbt.tags.LongArrayTag;
import net.lenni0451.mcstructs.nbt.tags.LongTag;
import net.lenni0451.mcstructs.nbt.tags.ShortTag;
import net.lenni0451.mcstructs.nbt.tags.StringTag;
import net.lenni0451.mcstructs_bedrock.nbt.io.impl.BedrockReadTypes;

public class BedrockNbtReader
implements INbtReader {
    public NbtHeader readHeader(DataInput in, NbtReadTracker readTracker) throws IOException {
        byte type = in.readByte();
        if (NbtType.END.getId() == type) {
            return NbtHeader.END;
        }
        return new NbtHeader(NbtType.byId((int)type), BedrockReadTypes.readString(in));
    }

    public ByteTag readByte(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(9);
        return new ByteTag(in.readByte());
    }

    public ShortTag readShort(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(10);
        return new ShortTag(in.readShort());
    }

    public IntTag readInt(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(12);
        return new IntTag(BedrockReadTypes.readVarInt(in));
    }

    public LongTag readLong(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(16);
        return new LongTag(BedrockReadTypes.readVarLong(in));
    }

    public FloatTag readFloat(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(12);
        return new FloatTag(in.readFloat());
    }

    public DoubleTag readDouble(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(16);
        return new DoubleTag(in.readDouble());
    }

    public ByteArrayTag readByteArray(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(24);
        int length = BedrockReadTypes.readVarInt(in);
        readTracker.read(length);
        byte[] value = new byte[length];
        in.readFully(value);
        return new ByteArrayTag(value);
    }

    public StringTag readString(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(36);
        String value = BedrockReadTypes.readString(in);
        readTracker.read(2 * value.length());
        return new StringTag(value);
    }

    public ListTag<?> readList(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(37);
        byte typeId = in.readByte();
        int count = BedrockReadTypes.readVarInt(in);
        if (typeId == NbtType.END.getId() && count > 0) {
            throw new NbtReadException("ListNbt with type END and count > 0");
        }
        readTracker.read(4 * count);
        NbtType type = NbtType.byId((int)typeId);
        ArrayList<INbtTag> value = new ArrayList<INbtTag>(Math.min(count, 512));
        for (int i = 0; i < count; ++i) {
            readTracker.pushDepth();
            INbtTag tag = this.read(type, in, readTracker);
            readTracker.popDepth();
            value.add(tag);
        }
        return new ListTag(type, value);
    }

    public CompoundTag readCompound(DataInput in, NbtReadTracker readTracker) throws IOException {
        NbtHeader header;
        readTracker.read(48);
        HashMap<String, INbtTag> value = new HashMap<String, INbtTag>();
        while (!(header = this.readHeader(in, readTracker)).isEnd()) {
            readTracker.read(28 + 2 * header.getName().length());
            readTracker.pushDepth();
            INbtTag tag = this.read(header.getType(), in, readTracker);
            readTracker.popDepth();
            if (value.put(header.getName(), tag) == null) continue;
            readTracker.read(36);
        }
        return new CompoundTag(value);
    }

    public IntArrayTag readIntArray(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(24);
        int length = BedrockReadTypes.readVarInt(in);
        readTracker.read(4 * length);
        int[] value = new int[length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = BedrockReadTypes.readVarInt(in);
        }
        return new IntArrayTag(value);
    }

    public LongArrayTag readLongArray(DataInput in, NbtReadTracker readTracker) throws IOException {
        readTracker.read(24);
        int length = BedrockReadTypes.readVarInt(in);
        readTracker.read(8 * length);
        long[] value = new long[length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = BedrockReadTypes.readVarLong(in);
        }
        return new LongArrayTag(value);
    }
}

