/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.swing.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import javax.swing.JPanel;

public abstract class OverlayPanel
extends JPanel {
    private static final MouseAdapter VOID_MOUSE_ADAPTER = new MouseAdapter(){};
    private static final KeyAdapter VOID_KEY_ADAPTER = new KeyAdapter(){};
    private static final FocusAdapter STEALING_FOCUS_ADAPTER = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            e.getComponent().requestFocus();
        }
    };
    private final Color backgroundColor;

    public OverlayPanel(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.setOpaque(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addMouseListener(VOID_MOUSE_ADAPTER);
        this.addMouseMotionListener(VOID_MOUSE_ADAPTER);
        this.addMouseWheelListener(VOID_MOUSE_ADAPTER);
        this.addKeyListener(VOID_KEY_ADAPTER);
        this.addFocusListener(STEALING_FOCUS_ADAPTER);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeMouseListener(VOID_MOUSE_ADAPTER);
        this.removeMouseMotionListener(VOID_MOUSE_ADAPTER);
        this.removeMouseWheelListener(VOID_MOUSE_ADAPTER);
        this.removeKeyListener(VOID_KEY_ADAPTER);
        this.removeFocusListener(STEALING_FOCUS_ADAPTER);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintOverlay(g);
        super.paintComponent(g);
    }

    protected abstract void paintOverlay(Graphics var1);
}

