/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.netty.bootstrap.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.DatagramChannel;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.lenni0451.commons.netty.UDPChannelType;

public class UDPClientServer {
    public static final AttributeKey<UDPClientServer> ATTRIBUTE_CLIENT_SERVER = AttributeKey.valueOf((String)"commons-netty UDPClientServer");
    protected final ChannelInitializer<DatagramChannel> channelInitializer;
    protected final UDPChannelType channelType;
    protected final Bootstrap bootstrap;
    protected ChannelFuture channelFuture;

    public UDPClientServer(ChannelInitializer<DatagramChannel> channelInitializer) {
        this(channelInitializer, UDPChannelType.getBest());
    }

    public UDPClientServer(ChannelInitializer<DatagramChannel> channelInitializer, UDPChannelType channelType) {
        this.channelInitializer = channelInitializer;
        this.channelType = channelType;
        this.bootstrap = new Bootstrap();
    }

    public UDPChannelType getChannelType() {
        return this.channelType;
    }

    protected void configureBootstrap() {
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.channelType.getClientLoopGroup())).channel(this.channelType.getChannelClass())).attr(ATTRIBUTE_CLIENT_SERVER, (Object)this)).handler(this.channelInitializer);
    }

    public void bind(String host, int port, boolean sync) {
        this.configureBootstrap();
        this.channelFuture = ((Bootstrap)this.bootstrap.localAddress(host, port)).bind();
        if (sync) {
            this.channelFuture.syncUninterruptibly();
        }
    }

    public void connect(String host, int port, boolean sync) {
        this.connect(new InetSocketAddress(host, port), sync);
    }

    public void connect(SocketAddress address, boolean sync) {
        this.configureBootstrap();
        this.channelFuture = this.bootstrap.connect(address);
        if (sync) {
            this.channelFuture.syncUninterruptibly();
        }
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public void close() {
        this.channelFuture.channel().close();
    }
}

