/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.netty.bootstrap.types;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class ReliableServer {
    protected final ChannelInitializer<Channel> channelInitializer;
    protected final ServerBootstrap bootstrap;
    protected ChannelFuture channelFuture;

    public ReliableServer(ChannelInitializer<Channel> channelInitializer) {
        this.channelInitializer = channelInitializer;
        this.bootstrap = new ServerBootstrap();
    }

    protected abstract void configureBootstrap();

    public void bind(String bindAddress, int bindPort, boolean sync) {
        this.bind(new InetSocketAddress(bindAddress, bindPort), sync);
    }

    public void bind(SocketAddress bindAddress, boolean sync) {
        this.configureBootstrap();
        this.channelFuture = this.bootstrap.bind(bindAddress);
        if (sync) {
            this.channelFuture.syncUninterruptibly();
        }
    }

    public ServerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public void close() {
        this.channelFuture.channel().close();
    }
}

