/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.netty.bootstrap.types;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class ReliableClient {
    protected final ChannelInitializer<Channel> channelInitializer;
    protected final Bootstrap bootstrap;
    protected ChannelFuture channelFuture;

    public ReliableClient(ChannelInitializer<Channel> channelInitializer) {
        this.channelInitializer = channelInitializer;
        this.bootstrap = new Bootstrap();
    }

    protected abstract void configureBootstrap();

    public void connect(String ip, int port, boolean sync) {
        this.connect(new InetSocketAddress(ip, port), sync);
    }

    public void connect(SocketAddress address, boolean sync) {
        this.configureBootstrap();
        this.channelFuture = this.bootstrap.register().channel().connect(address);
        if (sync) {
            this.channelFuture.syncUninterruptibly();
        }
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public void close() {
        this.channelFuture.channel().close();
    }
}

