/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.netty.bootstrap.raknet;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.DatagramChannel;
import java.util.Random;
import net.lenni0451.commons.netty.UDPChannelType;
import net.lenni0451.commons.netty.bootstrap.types.ReliableServer;
import org.cloudburstmc.netty.channel.raknet.RakChannelFactory;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;

public class RaknetServer
extends ReliableServer {
    public static final int MAX_ORDERING_CHANNELS = 16;
    private static final Random RND = new Random();
    private final UDPChannelType channelType;
    private long sessionTimeout = 30000L;

    public RaknetServer(ChannelInitializer<Channel> channelInitializer) {
        this(channelInitializer, UDPChannelType.getBest());
    }

    public RaknetServer(ChannelInitializer<Channel> channelInitializer, UDPChannelType channelType) {
        super(channelInitializer);
        this.channelType = channelType;
        if (!DatagramChannel.class.isAssignableFrom(this.channelType.getChannelClass())) {
            throw new IllegalArgumentException("RakNet does not support Unix Domain Sockets");
        }
    }

    public UDPChannelType getChannelType() {
        return this.channelType;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    protected void configureBootstrap() {
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.channelType.getServerParentLoopGroup(), this.channelType.getServerChildLoopGroup()).channelFactory((ChannelFactory)RakChannelFactory.server(this.channelType.getChannelClass()))).childOption(ChannelOption.IP_TOS, (Object)24).childOption(RakChannelOption.RAK_SESSION_TIMEOUT, (Object)this.sessionTimeout).childOption(RakChannelOption.RAK_ORDERING_CHANNELS, (Object)16).option(RakChannelOption.RAK_GUID, (Object)RND.nextLong())).option(RakChannelOption.RAK_MAX_CONNECTIONS, (Object)Integer.MAX_VALUE)).option(RakChannelOption.RAK_SUPPORTED_PROTOCOLS, (Object)new int[]{11})).childHandler((ChannelHandler)this.channelInitializer);
    }
}

