/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.netty.bootstrap.raknet;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.DatagramChannel;
import java.util.Random;
import net.lenni0451.commons.netty.UDPChannelType;
import net.lenni0451.commons.netty.bootstrap.types.ReliableClient;
import org.cloudburstmc.netty.channel.raknet.RakChannelFactory;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;

public class RaknetClient
extends ReliableClient {
    public static final int MAX_ORDERING_CHANNELS = 16;
    private static final Random RND = new Random();
    private final UDPChannelType channelType;
    private long connectTimeout = 5000L;
    private long sessionTimeout = 30000L;

    public RaknetClient(ChannelInitializer<Channel> channelInitializer) {
        this(channelInitializer, UDPChannelType.getBest());
    }

    public RaknetClient(ChannelInitializer<Channel> channelInitializer, UDPChannelType channelType) {
        super(channelInitializer);
        this.channelType = channelType;
        if (!DatagramChannel.class.isAssignableFrom(this.channelType.getChannelClass())) {
            throw new IllegalArgumentException("RakNet does not support Unix Domain Sockets");
        }
    }

    public UDPChannelType getChannelType() {
        return this.channelType;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    protected void configureBootstrap() {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.channelType.getClientLoopGroup())).channelFactory((ChannelFactory)RakChannelFactory.client(this.channelType.getChannelClass()))).option(ChannelOption.IP_TOS, (Object)24)).option(RakChannelOption.RAK_CONNECT_TIMEOUT, (Object)this.connectTimeout)).option(RakChannelOption.RAK_SESSION_TIMEOUT, (Object)this.sessionTimeout)).option(RakChannelOption.RAK_GUID, (Object)RND.nextLong())).option(RakChannelOption.RAK_PROTOCOL_VERSION, (Object)11)).option(RakChannelOption.RAK_ORDERING_CHANNELS, (Object)16)).handler((ChannelHandler)this.channelInitializer);
    }
}

