/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.netty;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDomainDatagramChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainDatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import net.lenni0451.commons.netty.LazyGroups;

public enum UDPChannelType {
    NIO(NioDatagramChannel.class, LazyGroups.NIO),
    EPOLL(EpollDatagramChannel.class, LazyGroups.EPOLL),
    KQUEUE(KQueueDatagramChannel.class, LazyGroups.KQUEUE),
    UNIX_EPOLL(EpollDomainDatagramChannel.class, LazyGroups.EPOLL),
    UNIX_KQUEUE(KQueueDomainDatagramChannel.class, LazyGroups.KQUEUE);

    private final Class<? extends Channel> channelClass;
    private final LazyGroups lazyGroups;

    public static UDPChannelType getBest() {
        if (Epoll.isAvailable()) {
            return EPOLL;
        }
        if (KQueue.isAvailable()) {
            return KQUEUE;
        }
        return NIO;
    }

    private UDPChannelType(Class<? extends Channel> channelClass, LazyGroups lazyGroups) {
        this.channelClass = channelClass;
        this.lazyGroups = lazyGroups;
    }

    public Class<? extends Channel> getChannelClass() {
        return this.channelClass;
    }

    public EventLoopGroup getClientLoopGroup() {
        return (EventLoopGroup)this.lazyGroups.getClientLoopGroup().get();
    }

    public EventLoopGroup getServerParentLoopGroup() {
        return (EventLoopGroup)this.lazyGroups.getServerParentLoopGroup().get();
    }

    public EventLoopGroup getServerChildLoopGroup() {
        return (EventLoopGroup)this.lazyGroups.getServerChildLoopGroup().get();
    }
}

