/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.netty;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import net.lenni0451.commons.netty.LazyGroups;

public enum TCPChannelType {
    NIO(NioSocketChannel.class, NioServerSocketChannel.class, LazyGroups.NIO),
    EPOLL(EpollSocketChannel.class, EpollServerSocketChannel.class, LazyGroups.EPOLL),
    KQUEUE(KQueueSocketChannel.class, KQueueServerSocketChannel.class, LazyGroups.KQUEUE),
    UNIX_EPOLL(EpollDomainSocketChannel.class, EpollServerDomainSocketChannel.class, LazyGroups.EPOLL),
    UNIX_KQUEUE(KQueueDomainSocketChannel.class, KQueueServerDomainSocketChannel.class, LazyGroups.KQUEUE);

    private final Class<? extends Channel> clientChannel;
    private final Class<? extends ServerChannel> serverChannel;
    private final LazyGroups lazyGroups;

    public static TCPChannelType getBest() {
        if (Epoll.isAvailable()) {
            return EPOLL;
        }
        if (KQueue.isAvailable()) {
            return KQUEUE;
        }
        return NIO;
    }

    private TCPChannelType(Class<? extends Channel> clientChannel, Class<? extends ServerChannel> serverChannel, LazyGroups lazyGroups) {
        this.clientChannel = clientChannel;
        this.serverChannel = serverChannel;
        this.lazyGroups = lazyGroups;
    }

    public Class<? extends Channel> getClientChannel() {
        return this.clientChannel;
    }

    public EventLoopGroup getClientLoopGroup() {
        return (EventLoopGroup)this.lazyGroups.getClientLoopGroup().get();
    }

    public Class<? extends ServerChannel> getServerChannel() {
        return this.serverChannel;
    }

    public EventLoopGroup getServerParentLoopGroup() {
        return (EventLoopGroup)this.lazyGroups.getServerParentLoopGroup().get();
    }

    public EventLoopGroup getServerChildLoopGroup() {
        return (EventLoopGroup)this.lazyGroups.getServerChildLoopGroup().get();
    }
}

