/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.logging.impl;

import java.io.PrintStream;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import net.lenni0451.commons.logging.MessageFormat;
import net.lenni0451.commons.logging.impl.PrintStreamLogger;

public class SysoutLogger
extends PrintStreamLogger {
    public static Builder builder() {
        return new Builder();
    }

    public SysoutLogger(@Nullable String name, MessageFormat messageFormat, OutStream warnStream, boolean printLevel) {
        super((PrintStreamLogger.LogLevel level) -> level == PrintStreamLogger.LogLevel.INFO ? System.out : warnStream.getStreamSupplier().get(), (name == null ? "" : "[" + name + "] ") + (printLevel ? "(%level%) " : ""), messageFormat);
    }

    public static class Builder {
        @Nullable
        private String name;
        private MessageFormat messageFormat = MessageFormat.CURLY_BRACKETS;
        private OutStream warnStream = OutStream.ERR;
        private boolean printLevel = true;

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder messageFormat(MessageFormat messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        public Builder warnStream(OutStream warnStream) {
            this.warnStream = warnStream;
            return this;
        }

        public Builder printLevel(boolean printLevel) {
            this.printLevel = printLevel;
            return this;
        }

        public SysoutLogger build() {
            return new SysoutLogger(this.name, this.messageFormat, this.warnStream, this.printLevel);
        }
    }

    public static enum OutStream {
        OUT(() -> System.out),
        ERR(() -> System.err);

        private final Supplier<PrintStream> streamSupplier;

        @Generated
        public Supplier<PrintStream> getStreamSupplier() {
            return this.streamSupplier;
        }

        @Generated
        private OutStream(Supplier<PrintStream> streamSupplier) {
            this.streamSupplier = streamSupplier;
        }
    }
}

