/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.logging.impl;

import java.io.PrintStream;
import java.util.function.Function;
import net.lenni0451.commons.logging.Logger;
import net.lenni0451.commons.logging.MessageFormat;

public class PrintStreamLogger
implements Logger {
    private final Function<LogLevel, PrintStream> stream;
    private final String prefix;
    private final MessageFormat messageFormat;

    public PrintStreamLogger(PrintStream stream, String prefix, MessageFormat messageFormat) {
        this((LogLevel level) -> stream, prefix, messageFormat);
    }

    public PrintStreamLogger(Function<LogLevel, PrintStream> stream, String prefix, MessageFormat messageFormat) {
        this.stream = stream;
        this.prefix = prefix;
        this.messageFormat = messageFormat;
    }

    @Override
    public void info(String message, Object ... args) {
        this.log(this.stream.apply(LogLevel.INFO), "INFO", message, args);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.log(this.stream.apply(LogLevel.WARN), "WARN", message, args);
    }

    @Override
    public void error(String message, Object ... args) {
        this.log(this.stream.apply(LogLevel.ERROR), "ERROR", message, args);
    }

    protected void log(PrintStream stream, String level, String message, Object[] args) {
        MessageFormat.Result result = this.messageFormat.format(message, args);
        stream.println(this.prefix.replace("%level%", level) + result.getMessage());
        if (result.getThrowable() != null) {
            result.getThrowable().printStackTrace(stream);
        }
    }

    public static enum LogLevel {
        INFO,
        WARN,
        ERROR;

    }
}

