/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.logging.impl;

import java.util.logging.Level;
import net.lenni0451.commons.logging.Logger;
import net.lenni0451.commons.logging.MessageFormat;

public class JavaLogger
implements Logger {
    private final java.util.logging.Logger logger;
    private final MessageFormat messageFormat;

    public JavaLogger(String name) {
        this(name, MessageFormat.CURLY_BRACKETS);
    }

    public JavaLogger(String name, MessageFormat messageFormat) {
        this(java.util.logging.Logger.getLogger(name), messageFormat);
    }

    public JavaLogger(java.util.logging.Logger logger) {
        this(logger, MessageFormat.CURLY_BRACKETS);
    }

    public JavaLogger(java.util.logging.Logger logger, MessageFormat messageFormat) {
        this.logger = logger;
        this.messageFormat = messageFormat;
    }

    @Override
    public void info(String message, Object ... args) {
        this.log(Level.INFO, message, args);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.log(Level.WARNING, message, args);
    }

    @Override
    public void error(String message, Object ... args) {
        this.log(Level.SEVERE, message, args);
    }

    private void log(Level level, String message, Object[] args) {
        MessageFormat.Result result = this.messageFormat.format(message, args);
        this.logger.log(level, result.getMessage(), result.getThrowable());
    }
}

