/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.logging.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import net.lenni0451.commons.logging.MessageFormat;
import net.lenni0451.commons.logging.impl.PrintStreamLogger;

public class FileLogger
extends PrintStreamLogger
implements AutoCloseable {
    private final FileOutputStream fileOutputStream;

    public static Builder builder() {
        return new Builder();
    }

    public FileLogger(FileOutputStream fos, String prefix, MessageFormat messageFormat) {
        super(new PrintStream(fos), prefix, messageFormat);
        this.fileOutputStream = fos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void log(PrintStream stream, String level, String message, Object[] args) {
        FileOutputStream fileOutputStream = this.fileOutputStream;
        synchronized (fileOutputStream) {
            super.log(stream, level, message, args);
        }
    }

    @Override
    public void close() throws Exception {
        this.fileOutputStream.close();
    }

    public static class Builder {
        private FileOutputStream fos;
        private String prefix = "";
        private MessageFormat messageFormat = MessageFormat.CURLY_BRACKETS;

        public Builder file(File file) throws FileNotFoundException {
            return this.fileOutputStream(new FileOutputStream(file));
        }

        public Builder fileOutputStream(FileOutputStream fos) {
            this.fos = fos;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder messageFormat(MessageFormat messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        public FileLogger build() {
            return new FileLogger(this.fos, this.prefix, this.messageFormat);
        }
    }
}

