/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.logging;

import java.util.Arrays;
import javax.annotation.Nullable;
import lombok.Generated;

public interface MessageFormat {
    public static final MessageFormat CURLY_BRACKETS = (message, args) -> {
        MessageArgs messageArgs = MessageFormat.split(args);
        StringBuilder builder = new StringBuilder();
        String left = message;
        int index = 0;
        while (left.contains("{}")) {
            int i = left.indexOf("{}");
            builder.append(left, 0, i);
            builder.append(messageArgs.getArg(index++, "{}"));
            left = left.substring(i + 2);
        }
        builder.append(left);
        return new Result(builder.toString(), messageArgs.getThrowable());
    };
    public static final MessageFormat STRING_FORMAT = (message, args) -> {
        MessageArgs messageArgs = MessageFormat.split(args);
        return new Result(String.format(message, messageArgs.getArgs()), messageArgs.getThrowable());
    };

    public static MessageArgs split(Object[] args) {
        if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
            return new MessageArgs(Arrays.copyOfRange(args, 0, args.length - 1), (Throwable)args[args.length - 1]);
        }
        return new MessageArgs(args, null);
    }

    public Result format(String var1, Object ... var2);

    public static final class Result {
        private final String message;
        @Nullable
        private final Throwable throwable;

        @Generated
        public Result(String message, @Nullable Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Nullable
        @Generated
        public Throwable getThrowable() {
            return this.throwable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MessageFormat.Result(message=" + this.getMessage() + ", throwable=" + this.getThrowable() + ")";
        }
    }

    public static final class MessageArgs {
        private final Object[] args;
        @Nullable
        private final Throwable throwable;

        public Object getArg(int index, String def) {
            if (index < 0 || index >= this.args.length) {
                return def;
            }
            return this.args[index];
        }

        @Generated
        public MessageArgs(Object[] args, @Nullable Throwable throwable) {
            this.args = args;
            this.throwable = throwable;
        }

        @Generated
        public Object[] getArgs() {
            return this.args;
        }

        @Nullable
        @Generated
        public Throwable getThrowable() {
            return this.throwable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageArgs)) {
                return false;
            }
            MessageArgs other = (MessageArgs)o;
            if (!Arrays.deepEquals(this.getArgs(), other.getArgs())) {
                return false;
            }
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getArgs());
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MessageFormat.MessageArgs(args=" + Arrays.deepToString(this.getArgs()) + ", throwable=" + this.getThrowable() + ")";
        }
    }
}

