/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.logging;

import java.lang.reflect.Constructor;
import net.lenni0451.commons.logging.Logger;
import net.lenni0451.commons.logging.impl.SysoutLogger;

public class LoggerFactory {
    public static final String SYSTEM_PROPERTY = "net.lenni0451.commons.logging.LoggerFactory";
    private static Builder builder;

    public static void setBuilder(Builder builder) {
        LoggerFactory.builder = builder;
    }

    public static Logger getLogger(String name) {
        return builder.build(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return builder.build(clazz);
    }

    static {
        try {
            String builderName = System.getProperty(SYSTEM_PROPERTY);
            if (builderName == null) {
                builder = new DefaultBuilder();
            } else {
                Class<?> builderClass = Class.forName(builderName);
                Constructor<?> constructor = builderClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                builder = (Builder)constructor.newInstance(new Object[0]);
            }
        }
        catch (Throwable t) {
            builder = new DefaultBuilder();
        }
    }

    private static class DefaultBuilder
    implements Builder {
        private DefaultBuilder() {
        }

        @Override
        public Logger build(String name) {
            return SysoutLogger.builder().name(name).build();
        }
    }

    public static interface Builder {
        public Logger build(String var1);

        default public Logger build(Class<?> clazz) {
            return this.build(clazz.getSimpleName());
        }
    }
}

