/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.gson.elements;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.commons.gson.elements.GsonElement;

public class GsonArray
extends GsonElement
implements Iterable<GsonElement> {
    private final JsonArray array;

    public GsonArray() {
        this(new JsonArray());
    }

    public GsonArray(JsonArray array) {
        super((JsonElement)array);
        this.array = array;
    }

    public JsonArray getJsonArray() {
        return this.array;
    }

    public GsonArray add(@Nullable JsonElement element) {
        this.array.add(element);
        return this;
    }

    public GsonArray add(@Nullable GsonElement element) {
        this.array.add(element == null ? null : element.getJsonElement());
        return this;
    }

    public GsonArray add(boolean b) {
        this.array.add(Boolean.valueOf(b));
        return this;
    }

    public GsonArray add(@Nullable Number number) {
        this.array.add(number);
        return this;
    }

    public GsonArray add(@Nullable String s) {
        this.array.add(s);
        return this;
    }

    public GsonArray addAll(JsonArray other) {
        this.array.addAll(other);
        return this;
    }

    public GsonArray addAll(GsonArray other) {
        this.array.addAll(other.getJsonArray());
        return this;
    }

    public GsonElement set(int index, JsonElement element) {
        JsonElement previous = this.array.set(index, element);
        if (previous == null) {
            return null;
        }
        return GsonElement.wrap(previous);
    }

    public GsonElement set(int index, GsonElement element) {
        JsonElement previous = this.array.set(index, element.getJsonElement());
        if (previous == null) {
            return null;
        }
        return GsonElement.wrap(previous);
    }

    public GsonElement set(int index, boolean b) {
        JsonElement previous = this.array.set(index, (JsonElement)new JsonPrimitive(Boolean.valueOf(b)));
        if (previous == null) {
            return null;
        }
        return GsonElement.wrap(previous);
    }

    public GsonElement set(int index, Number number) {
        JsonElement previous = this.array.set(index, (JsonElement)new JsonPrimitive(number));
        if (previous == null) {
            return null;
        }
        return GsonElement.wrap(previous);
    }

    public GsonElement set(int index, String s) {
        JsonElement previous = this.array.set(index, (JsonElement)new JsonPrimitive(s));
        if (previous == null) {
            return null;
        }
        return GsonElement.wrap(previous);
    }

    public GsonElement get(int index) {
        return GsonElement.wrap(this.array.get(index));
    }

    public GsonElement remove(int index) {
        JsonElement previous = this.array.remove(index);
        if (previous == null) {
            return null;
        }
        return GsonElement.wrap(previous);
    }

    public boolean remove(@Nullable JsonElement element) {
        return this.array.remove((JsonElement)(element == null ? JsonNull.INSTANCE : element));
    }

    public boolean remove(@Nullable GsonElement element) {
        return this.array.remove((JsonElement)(element == null ? JsonNull.INSTANCE : element.getJsonElement()));
    }

    public boolean removeBoolean(boolean b) {
        return this.remove((JsonElement)new JsonPrimitive(Boolean.valueOf(b)));
    }

    public boolean removeNumber(Number number) {
        return this.remove((JsonElement)new JsonPrimitive(number));
    }

    public boolean removeString(String s) {
        return this.remove((JsonElement)new JsonPrimitive(s));
    }

    public boolean removeAll(JsonArray other) {
        boolean changed = false;
        for (JsonElement element : other) {
            changed |= this.array.remove(element);
        }
        return changed;
    }

    public boolean removeAll(GsonArray other) {
        return this.removeAll(other.getJsonArray());
    }

    public GsonArray clear() {
        while (!this.array.isEmpty()) {
            this.array.remove(0);
        }
        return this;
    }

    public boolean has(int index) {
        return index >= 0 && index < this.array.size();
    }

    public boolean has(@Nullable JsonElement element) {
        return this.array.contains((JsonElement)(element == null ? JsonNull.INSTANCE : element));
    }

    public boolean has(@Nullable GsonElement element) {
        return this.array.contains((JsonElement)(element == null ? JsonNull.INSTANCE : element.getJsonElement()));
    }

    public int size() {
        return this.array.size();
    }

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    @Override
    @Nonnull
    public Iterator<GsonElement> iterator() {
        return new WrappedIterator(this.array.iterator());
    }

    public Stream<GsonElement> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public List<GsonElement> asList() {
        ArrayList<GsonElement> list = new ArrayList<GsonElement>();
        for (JsonElement element : this.array) {
            list.add(GsonElement.wrap(element));
        }
        return list;
    }

    public <T extends GsonElement> List<T> asList(Function<GsonElement, T> mapper) {
        ArrayList<T> list = new ArrayList<T>();
        for (JsonElement element : this.array) {
            list.add(mapper.apply(GsonElement.wrap(element)));
        }
        return list;
    }

    private static class WrappedIterator
    implements Iterator<GsonElement> {
        private final Iterator<JsonElement> iterator;

        public WrappedIterator(Iterator<JsonElement> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public GsonElement next() {
            return GsonElement.wrap(this.iterator.next());
        }
    }
}

