/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.gson.elements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.commons.gson.elements.GsonArray;
import net.lenni0451.commons.gson.elements.GsonElement;
import net.lenni0451.commons.gson.elements.GsonPrimitive;

public class GsonObject
extends GsonElement
implements Iterable<Map.Entry<String, GsonElement>> {
    private final JsonObject object;

    public GsonObject() {
        this(new JsonObject());
    }

    public GsonObject(JsonObject object) {
        super((JsonElement)object);
        this.object = object;
    }

    public JsonObject getJsonObject() {
        return this.object;
    }

    public GsonObject add(String key, @Nullable JsonElement element) {
        this.object.add(key, element);
        return this;
    }

    public GsonObject add(String key, @Nullable GsonElement element) {
        this.object.add(key, element == null ? null : element.getJsonElement());
        return this;
    }

    public GsonObject add(String key, boolean b) {
        this.object.addProperty(key, Boolean.valueOf(b));
        return this;
    }

    public GsonObject add(String key, @Nullable Number number) {
        this.object.addProperty(key, number);
        return this;
    }

    public GsonObject add(String key, @Nullable String s) {
        this.object.addProperty(key, s);
        return this;
    }

    public GsonElement remove(String key) {
        JsonElement previous = this.object.remove(key);
        if (previous == null) {
            return null;
        }
        return GsonElement.wrap(previous);
    }

    public GsonObject clear() {
        this.object.asMap().clear();
        return this;
    }

    public boolean has(String key) {
        return this.object.has(key);
    }

    public boolean hasObject(String key) {
        return this.object.has(key) && this.object.get(key).isJsonObject();
    }

    public boolean hasArray(String key) {
        return this.object.has(key) && this.object.get(key).isJsonArray();
    }

    public boolean hasPrimitive(String key) {
        return this.object.has(key) && this.object.get(key).isJsonPrimitive();
    }

    public boolean hasBoolean(String key) {
        return this.object.has(key) && this.object.get(key).isJsonPrimitive() && this.object.get(key).getAsJsonPrimitive().isBoolean();
    }

    public boolean hasNumber(String key) {
        return this.object.has(key) && this.object.get(key).isJsonPrimitive() && this.object.get(key).getAsJsonPrimitive().isNumber();
    }

    public boolean hasString(String key) {
        return this.object.has(key) && this.object.get(key).isJsonPrimitive() && this.object.get(key).getAsJsonPrimitive().isString();
    }

    public GsonElement get(String key) {
        return this.get(key, null);
    }

    public GsonElement get(String key, @Nullable GsonElement defaultValue) {
        return this.has(key) ? GsonElement.wrap(this.object.get(key)) : defaultValue;
    }

    public Optional<GsonElement> opt(String key) {
        return Optional.ofNullable(this.get(key, null));
    }

    public GsonObject getObject(String key) {
        return this.getObject(key, null);
    }

    public GsonObject getObject(String key, @Nullable GsonObject defaultValue) {
        return this.hasObject(key) ? this.get(key, defaultValue).asObject() : defaultValue;
    }

    public Optional<GsonObject> optObject(String key) {
        return Optional.ofNullable(this.getObject(key, null));
    }

    public GsonArray getArray(String key) {
        return this.getArray(key, null);
    }

    public GsonArray getArray(String key, @Nullable GsonArray defaultValue) {
        return this.hasArray(key) ? this.get(key, defaultValue).asArray() : defaultValue;
    }

    public Optional<GsonArray> optArray(String key) {
        return Optional.ofNullable(this.getArray(key, null));
    }

    public GsonPrimitive getPrimitive(String key) {
        return this.getPrimitive(key, null);
    }

    public GsonPrimitive getPrimitive(String key, @Nullable GsonPrimitive defaultValue) {
        return this.hasPrimitive(key) ? this.get(key, defaultValue).asPrimitive() : defaultValue;
    }

    public Optional<GsonPrimitive> optPrimitive(String key) {
        return Optional.ofNullable(this.getPrimitive(key, null));
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.hasBoolean(key) ? this.object.get(key).getAsBoolean() : defaultValue;
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.hasNumber(key) ? this.object.get(key).getAsByte() : defaultValue;
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        return this.hasNumber(key) ? this.object.get(key).getAsShort() : defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        return this.hasNumber(key) ? this.object.get(key).getAsInt() : defaultValue;
    }

    public OptionalInt optInt(String key) {
        return this.hasNumber(key) ? OptionalInt.of(this.object.get(key).getAsInt()) : OptionalInt.empty();
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        return this.hasNumber(key) ? this.object.get(key).getAsLong() : defaultValue;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return this.hasNumber(key) ? this.object.get(key).getAsFloat() : defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        return this.hasNumber(key) ? this.object.get(key).getAsDouble() : defaultValue;
    }

    public OptionalDouble optDouble(String key) {
        return this.hasNumber(key) ? OptionalDouble.of(this.object.get(key).getAsDouble()) : OptionalDouble.empty();
    }

    public Number getNumber(String key) {
        return this.getNumber(key, null);
    }

    public Number getNumber(String key, @Nullable Number defaultValue) {
        return this.hasNumber(key) ? (Number)this.object.get(key).getAsNumber() : (Number)defaultValue;
    }

    public Optional<Number> optNumber(String key) {
        return Optional.ofNullable(this.getNumber(key, null));
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, @Nullable String defaultValue) {
        return this.hasString(key) ? this.object.get(key).getAsString() : defaultValue;
    }

    public Optional<String> optString(String key) {
        return Optional.ofNullable(this.getString(key, null));
    }

    public int size() {
        return this.object.size();
    }

    public boolean isEmpty() {
        return this.object.isEmpty();
    }

    public Set<String> keySet() {
        return this.object.keySet();
    }

    public Set<Map.Entry<String, GsonElement>> entrySet() {
        return this.object.entrySet().stream().map(WrappedMapEntry::new).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<String, GsonElement>> iterator() {
        return new WrappedIterator(this.object.entrySet().iterator());
    }

    public Stream<Map.Entry<String, GsonElement>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Map<String, GsonElement> asMap() {
        HashMap<String, GsonElement> map = new HashMap<String, GsonElement>();
        for (Map.Entry entry : this.object.entrySet()) {
            map.put((String)entry.getKey(), GsonElement.wrap((JsonElement)entry.getValue()));
        }
        return map;
    }

    private static class WrappedIterator
    implements Iterator<Map.Entry<String, GsonElement>> {
        private final Iterator<Map.Entry<String, JsonElement>> iterator;

        public WrappedIterator(Iterator<Map.Entry<String, JsonElement>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, GsonElement> next() {
            return new WrappedMapEntry(this.iterator.next());
        }
    }

    private static class WrappedMapEntry
    implements Map.Entry<String, GsonElement> {
        private final Map.Entry<String, JsonElement> entry;

        public WrappedMapEntry(Map.Entry<String, JsonElement> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey();
        }

        @Override
        public GsonElement getValue() {
            return GsonElement.wrap(this.entry.getValue());
        }

        @Override
        public GsonElement setValue(GsonElement value) {
            JsonElement previous = this.entry.setValue(value.getJsonElement());
            if (previous == null) {
                return null;
            }
            return GsonElement.wrap(previous);
        }
    }
}

