/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.time;

public class Timing {
    protected long time;
    protected boolean forcePass = false;

    public Timing() {
        this.reset();
    }

    public long getTime() {
        return this.time;
    }

    public void reset() {
        this.time = System.currentTimeMillis();
    }

    public void forcePass() {
        this.forcePass = true;
    }

    public long getPassedTime() {
        return System.currentTimeMillis() - this.time;
    }

    public boolean hasPassed(long time) {
        if (this.forcePass) {
            this.forcePass = false;
            return true;
        }
        return this.getPassedTime() >= time;
    }

    public long timeUntil(long time) {
        return time - this.getPassedTime();
    }

    public void waitUntil(long time) throws InterruptedException {
        if (this.forcePass) {
            this.forcePass = false;
            return;
        }
        Thread.sleep(this.timeUntil(time));
    }
}

