/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.time;

public class Timer {
    protected final long delay;
    protected long time;
    protected boolean forcePass = false;

    public Timer(long delay) {
        this.delay = delay;
        this.reset();
    }

    public long getDelay() {
        return this.delay;
    }

    public long getTime() {
        return this.time;
    }

    public void reset() {
        this.time = System.currentTimeMillis();
        this.forcePass = false;
    }

    public void forcePass() {
        this.forcePass = true;
    }

    public long getPassedTime() {
        return System.currentTimeMillis() - this.time;
    }

    public boolean hasPassed() {
        if (this.getPassedTime() >= this.delay || this.forcePass) {
            this.reset();
            return true;
        }
        return false;
    }

    public long timeUntil() {
        return this.delay - this.getPassedTime();
    }

    public long waitUntil() throws InterruptedException {
        long timeUntil = this.timeUntil();
        if (!this.forcePass && timeUntil > 0L) {
            Thread.sleep(timeUntil);
        }
        this.reset();
        return timeUntil;
    }
}

