/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.time;

import net.lenni0451.commons.time.Timer;

public class NanoTimer
extends Timer {
    public NanoTimer(long delay) {
        super(delay);
    }

    @Override
    public void reset() {
        this.time = System.nanoTime();
        this.forcePass = false;
    }

    @Override
    public long getPassedTime() {
        return System.nanoTime() - this.time;
    }

    @Override
    public long waitUntil() throws InterruptedException {
        long timeUntil = this.timeUntil();
        if (!this.forcePass && timeUntil > 0L) {
            Thread.sleep(timeUntil / 1000000L, (int)(timeUntil % 1000000L));
        }
        this.reset();
        return timeUntil;
    }
}

