/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.threading;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;

public final class ThreadUtils {
    private static final AtomicBoolean TIMER_HACK_THREAD_STARTED = new AtomicBoolean(false);
    private static final long SLEEP_PRECISION = TimeUnit.MILLISECONDS.toNanos(2L);
    private static final long SPIN_YIELD_PRECISION = TimeUnit.MICROSECONDS.toNanos(2L);

    public static void startTimerHackThread() {
        if (TIMER_HACK_THREAD_STARTED.compareAndSet(false, true)) {
            Thread thread = new Thread(() -> {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }, "TimerHackThread");
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static boolean sleep(long millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static void hybridSleep(float millis) {
        long ms = (long)millis;
        long ns = (long)((millis - (float)ms) * 1000000.0f);
        ThreadUtils.hybridSleep(ms, ns);
    }

    public static void hybridSleep(long millis, long nanos) {
        long timeLeft = TimeUnit.MILLISECONDS.toNanos(millis) + nanos;
        long end = System.nanoTime() + timeLeft;
        do {
            if (timeLeft >= SLEEP_PRECISION) {
                ThreadUtils.sleep(1L);
                continue;
            }
            if (timeLeft <= SPIN_YIELD_PRECISION) continue;
            Thread.yield();
        } while ((timeLeft = end - System.nanoTime()) > 0L);
    }

    @Generated
    private ThreadUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

