/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.threading;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.lenni0451.commons.threading.ThreadFactoryImpl;

public class ThreadScheduler {
    private final boolean taskThreads;
    private final ThreadFactory threadFactory;
    private final ScheduledExecutorService executor;

    public ThreadScheduler(boolean daemon, boolean taskThreads) {
        this.taskThreads = taskThreads;
        this.threadFactory = ThreadFactoryImpl.of("ThreadScheduler #").daemon(daemon);
        this.executor = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
    }

    public Thread execute(Runnable task) {
        Thread thread = this.threadFactory.newThread(task);
        thread.start();
        return thread;
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        return this.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit timeUnit) {
        return this.executor.schedule(this.wrapExecute(task), delay, timeUnit);
    }

    public ScheduledFuture<?> repeat(Runnable task, long repeatDelay) {
        return this.repeat(task, repeatDelay, repeatDelay);
    }

    public ScheduledFuture<?> repeat(Runnable task, long startDelay, long repeatDelay) {
        return this.repeat(task, startDelay, repeatDelay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> repeat(Runnable task, long repeatDelay, TimeUnit timeUnit) {
        return this.repeat(task, repeatDelay, repeatDelay, timeUnit);
    }

    public ScheduledFuture<?> repeat(Runnable task, long startDelay, long repeatDelay, TimeUnit timeUnit) {
        return this.executor.scheduleAtFixedRate(this.wrapExecute(task), startDelay, repeatDelay, timeUnit);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public boolean shutdown(long timeout) throws InterruptedException {
        return this.shutdown(timeout, TimeUnit.MILLISECONDS);
    }

    public boolean shutdown(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.shutdown();
        return this.executor.awaitTermination(timeout, timeUnit);
    }

    private Runnable wrapExecute(Runnable task) {
        if (!this.taskThreads) {
            return task;
        }
        return () -> this.execute(task);
    }
}

