/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.threading;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class ThreadFactoryImpl
implements ThreadFactory {
    private final AtomicInteger threadId = new AtomicInteger(0);
    private String name;
    private Boolean daemon;
    private Integer priority;
    private Thread.UncaughtExceptionHandler exceptionHandler;

    public static ThreadFactoryImpl of() {
        return new ThreadFactoryImpl();
    }

    public static ThreadFactoryImpl of(String name) {
        return new ThreadFactoryImpl().name(name);
    }

    public static ThreadFactoryImpl of(boolean daemon) {
        return new ThreadFactoryImpl().daemon(daemon);
    }

    public static ThreadFactoryImpl of(int priority) {
        return new ThreadFactoryImpl().priority(priority);
    }

    public static ThreadFactoryImpl of(Thread.UncaughtExceptionHandler exceptionHandler) {
        return new ThreadFactoryImpl().exceptionHandler(exceptionHandler);
    }

    private ThreadFactoryImpl() {
    }

    public ThreadFactoryImpl name(String name) {
        this.name = name;
        return this;
    }

    public ThreadFactoryImpl daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryImpl priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ThreadFactoryImpl exceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public Thread newThread(@Nonnull Runnable r) {
        Thread thread = this.name != null ? new Thread(r, this.name + this.threadId.getAndIncrement()) : new Thread(r);
        if (this.daemon != null) {
            thread.setDaemon(this.daemon);
        }
        if (this.priority != null) {
            thread.setPriority(this.priority);
        }
        if (this.exceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.exceptionHandler);
        }
        return thread;
    }
}

