/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.strings.search.tokens;

import java.util.Locale;
import net.lenni0451.commons.strings.search.tokens.ISearchToken;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RequiredToken
implements ISearchToken {
    private final String keyword;

    public RequiredToken(String keyword) {
        this.keyword = keyword.toLowerCase(Locale.ROOT);
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public boolean required() {
        return true;
    }

    @Override
    public int contains(String string) {
        int after;
        int index = string.indexOf(this.keyword);
        if (index == -1) {
            return 0;
        }
        int before = index > 0 ? (int)string.charAt(index - 1) : 32;
        int n = after = index + this.keyword.length() < string.length() ? (int)string.charAt(index + this.keyword.length()) : 32;
        if (before == 32 && after == 32) {
            return 2;
        }
        return 1;
    }
}

