/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.strings.search.tokens;

import java.util.ArrayList;
import java.util.List;
import net.lenni0451.commons.strings.StringReader;
import net.lenni0451.commons.strings.search.tokens.BinaryOrToken;
import net.lenni0451.commons.strings.search.tokens.ISearchToken;
import net.lenni0451.commons.strings.search.tokens.KeywordToken;
import net.lenni0451.commons.strings.search.tokens.RequiredToken;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class QueryTokenizer {
    public static List<ISearchToken> tokenize(String query) {
        ArrayList<ISearchToken> tokens = new ArrayList<ISearchToken>();
        StringReader reader = new StringReader(query).skipWhitespace();
        while (reader.hasNext()) {
            int start = reader.getIndex();
            if (reader.peek() == '\"' || reader.peek() == '\'') {
                char quote = reader.next();
                String remaining = reader.peekRemaining();
                reader.setIndex(start);
                if (remaining.indexOf(quote) == -1) {
                    tokens.add(new KeywordToken(reader.readWord()));
                    continue;
                }
                tokens.add(new RequiredToken(reader.readQuoted()));
                continue;
            }
            tokens.add(new KeywordToken(reader.readWord()));
        }
        return QueryTokenizer.mergeOr(tokens);
    }

    private static List<ISearchToken> mergeOr(List<ISearchToken> tokens) {
        ArrayList<ISearchToken> merged = new ArrayList<ISearchToken>();
        for (int i = 0; i < tokens.size(); ++i) {
            ISearchToken next;
            ISearchToken last = merged.isEmpty() ? null : (ISearchToken)merged.get(merged.size() - 1);
            ISearchToken current = tokens.get(i);
            ISearchToken iSearchToken = next = i == tokens.size() - 1 ? null : tokens.get(i + 1);
            if (last != null && next != null && current.getKeyword().equals("OR")) {
                merged.remove(merged.size() - 1);
                merged.add(new BinaryOrToken(last, next));
                ++i;
                continue;
            }
            merged.add(current);
        }
        return merged;
    }
}

