/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.strings.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lenni0451.commons.math.MathUtils;
import net.lenni0451.commons.strings.search.ResultFilter;
import net.lenni0451.commons.strings.search.SearchResult;
import net.lenni0451.commons.strings.search.tokens.ISearchToken;
import net.lenni0451.commons.strings.search.tokens.QueryTokenizer;

public class SearchEngine<T> {
    private final Supplier<? extends Iterable<T>> supplier;
    private final Function<T, String> toStringFunction;

    public SearchEngine(Supplier<? extends Iterable<T>> supplier, Function<T, String> toStringFunction) {
        this.supplier = supplier;
        this.toStringFunction = toStringFunction;
    }

    public SearchResult<T> search(ResultFilter filter, String query) {
        ArrayList<SearchScore<T>> results = new ArrayList<SearchScore<T>>();
        List<ISearchToken> tokens = QueryTokenizer.tokenize(query);
        if (tokens.isEmpty()) {
            return new SearchResult(query, 0, filter, Collections.emptyList(), true);
        }
        Iterator<T> it = this.supplier.get().iterator();
        boolean hasElements = false;
        while (it.hasNext()) {
            hasElements = true;
            T object = it.next();
            SearchScore<T> result2 = this.calculateScore(object, tokens);
            if (((SearchScore)result2).score <= 0) continue;
            results.add(result2);
        }
        if (!hasElements) {
            return new SearchResult(query, tokens.size(), filter, Collections.emptyList(), true);
        }
        results.sort((o1, o2) -> Integer.compare(((SearchScore)o2).score, ((SearchScore)o1).score));
        switch (filter) {
            case ALL: {
                break;
            }
            case GAP: {
                this.filterScoreGap(results);
                break;
            }
            case HIGHEST: {
                if (results.isEmpty()) break;
                int maxScore = ((SearchScore)results.get(0)).score;
                results.removeIf(result -> ((SearchScore)result).score < maxScore);
            }
        }
        ArrayList<Object> sortedResults = new ArrayList<Object>();
        for (SearchScore searchScore : results) {
            sortedResults.add(searchScore.object);
        }
        return new SearchResult(query, tokens.size(), filter, sortedResults, false);
    }

    private SearchScore<T> calculateScore(T object, List<ISearchToken> tokens) {
        String string = this.toStringFunction.apply(object).toLowerCase(Locale.ROOT);
        int score = 0;
        for (ISearchToken token : tokens) {
            int tokenScore = 0;
            tokenScore += token.matches(string);
            if (token.required() && (tokenScore += token.contains(string)) == 0) {
                return new SearchScore(object, 0);
            }
            score += tokenScore;
        }
        return new SearchScore(object, score);
    }

    private void filterScoreGap(List<SearchScore<T>> results) {
        int minScore;
        if (results.size() <= 1) {
            return;
        }
        int maxScore = ((SearchScore)results.get(0)).score;
        int gap = maxScore - (minScore = ((SearchScore)results.get(results.size() - 1)).score);
        if (gap <= 0) {
            return;
        }
        int minGap = MathUtils.ceilInt((float)gap / 2.0f);
        for (int i = results.size() - 1; i >= 0; --i) {
            if (((SearchScore)results.get(i)).score >= minScore + minGap) continue;
            results.remove(i);
        }
    }

    private static class SearchScore<T> {
        private final T object;
        private final int score;

        private SearchScore(T object, int score) {
            this.object = object;
            this.score = score;
        }
    }
}

