/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.strings;

import lombok.Generated;

public final class StringUtils {
    public static String uppercaseFirst(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String repeat(char c, int count) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            out.append(c);
        }
        return out.toString();
    }

    public static String repeat(String s, int count) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            out.append(s);
        }
        return out.toString();
    }

    public static String cut(String s, int length) {
        if (s.length() < length) {
            return s;
        }
        return s.substring(0, length);
    }

    public static String cut(String s, char filler, int length) {
        if (s.length() < length) {
            return s + StringUtils.repeat(filler, length - s.length());
        }
        return s.substring(0, length);
    }

    public static int count(String s, String toCount) {
        int count = s.length() - s.replace(toCount, "").length();
        return count / toCount.length();
    }

    public static String flip(String s) {
        char[] chars = s.toCharArray();
        char[] out = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            out[i] = chars[chars.length - i - 1];
        }
        return new String(out);
    }

    @Generated
    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

