/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.strings;

public class StringReader {
    private final String s;
    private int index;

    public StringReader(String s) {
        this.s = s;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (index < 0 || index > this.s.length()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + this.s.length());
        }
        this.index = index;
    }

    public boolean hasNext() {
        return this.index < this.s.length();
    }

    public char next() {
        this.check(1);
        return this.s.charAt(this.index++);
    }

    public char peek() {
        this.check(1);
        return this.s.charAt(this.index);
    }

    public String peek(int amount) {
        this.check(amount);
        return this.s.substring(this.index, this.index + amount);
    }

    public String peekRemaining() {
        return this.s.substring(this.index);
    }

    public StringReader skip() {
        this.skip(1);
        return this;
    }

    public StringReader skip(int amount) {
        this.check(amount);
        this.index += amount;
        return this;
    }

    public StringReader skipWhitespace() {
        while (this.hasNext() && Character.isWhitespace(this.peek())) {
            this.skip();
        }
        return this;
    }

    public StringReader skipUntil(char c) {
        while (this.hasNext() && this.peek() != c) {
            this.skip();
        }
        return this;
    }

    public String readUntil(char c) {
        StringBuilder sb = new StringBuilder();
        while (this.hasNext() && this.peek() != c) {
            sb.append(this.next());
        }
        return sb.toString();
    }

    public String readWord() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more characters to read");
        }
        StringBuilder sb = new StringBuilder();
        while (this.hasNext() && !Character.isWhitespace(this.peek())) {
            sb.append(this.next());
        }
        this.skipWhitespace();
        return sb.toString();
    }

    public String readQuoted() {
        if (this.peek() != '\"' && this.peek() != '\'') {
            throw new IllegalStateException("Expected a quote character at index " + this.index);
        }
        StringBuilder sb = new StringBuilder();
        char quote = this.next();
        while (this.hasNext() && this.peek() != quote) {
            sb.append(this.next());
        }
        if (this.hasNext()) {
            this.skip();
            this.skipWhitespace();
        }
        return sb.toString();
    }

    private void check(int count) {
        if (this.index + count > this.s.length()) {
            throw new IndexOutOfBoundsException("Index: " + this.index + ", Length: " + this.s.length());
        }
    }
}

