/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.network;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TorProxy {
    private static final Set<TorProxy> shutdownListener = Collections.newSetFromMap(new WeakHashMap());
    private final File torPath;
    private final int port;
    private final int controlPort;
    private Process torProcess;
    private int startProgress;

    public TorProxy(File torPath) {
        this(torPath, 0, 0);
    }

    public TorProxy(File torPath, int port) {
        this(torPath, port, 0);
    }

    public TorProxy(File torPath, int port, int controlPort) {
        this.torPath = torPath;
        this.port = this.getPort(port);
        this.controlPort = this.getPort(controlPort);
        shutdownListener.add(this);
    }

    public File getTorPath() {
        return this.torPath;
    }

    public int getPort() {
        return this.port;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public int getStartProgress() {
        return this.startProgress;
    }

    public boolean isRunning() {
        return this.torProcess != null && this.torProcess.isAlive();
    }

    public boolean isStarted() {
        return this.isRunning() && this.startProgress == 100;
    }

    public void start() throws IOException {
        if (this.isRunning()) {
            throw new IllegalStateException("Tor process is already running");
        }
        ProcessBuilder torProcessBuilder = new ProcessBuilder(this.torPath.getAbsolutePath(), "--SocksPort", String.valueOf(this.port), "--ControlPort", String.valueOf(this.controlPort));
        this.torProcess = torProcessBuilder.start();
        Thread startListener = new Thread(() -> {
            try {
                String line;
                Pattern percentPattern = Pattern.compile("(?<=\\s)\\d{1,3}(?=%\\s)");
                BufferedReader br = new BufferedReader(new InputStreamReader(this.torProcess.getInputStream()));
                while (this.startProgress < 100 && (line = br.readLine()) != null) {
                    Matcher matcher = percentPattern.matcher(line);
                    if (!matcher.find()) continue;
                    this.startProgress = Integer.parseInt(matcher.group());
                }
                this.startProgress = 100;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.kill();
            }
        }, "Tor Start Listener #" + this.port + " | " + this.controlPort);
        startListener.setDaemon(true);
        startListener.start();
    }

    public void stop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Tor process is not running");
        }
        this.torProcess.destroy();
        this.torProcess = null;
        this.startProgress = 0;
    }

    public void kill() {
        if (this.torProcess != null && this.torProcess.isAlive()) {
            this.torProcess.destroyForcibly();
            this.torProcess = null;
            this.startProgress = 0;
        }
    }

    public boolean reconnect() throws IOException {
        try (Socket controlSocket = new Socket();){
            controlSocket.connect(new InetSocketAddress("127.0.0.1", this.controlPort));
            InputStream is = controlSocket.getInputStream();
            OutputStream os = controlSocket.getOutputStream();
            String authResponse = this.sendControlMessage(is, os, "AUTHENTICATE");
            if (authResponse != null && !authResponse.startsWith("250")) {
                boolean bl = false;
                return bl;
            }
            String signalResponse = this.sendControlMessage(is, os, "SIGNAL NEWNYM");
            boolean bl = signalResponse == null || signalResponse.startsWith("250");
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getPort(int port) {
        if (port >= 1 && port <= 65535) {
            return port;
        }
        try (ServerSocket serverSocket = new ServerSocket();){
            serverSocket.bind(new InetSocketAddress("127.0.0.1", 0));
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            return ThreadLocalRandom.current().nextInt(65535) + 1;
        }
    }

    private String sendControlMessage(InputStream is, OutputStream os, String message) throws IOException {
        os.write((message + "\r\n").getBytes());
        os.flush();
        byte[] response = new byte[1024];
        int read = is.read(response);
        if (read == -1) {
            return null;
        }
        return new String(response, 0, read).trim();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> shutdownListener.stream().filter(TorProxy::isRunning).forEach(TorProxy::kill), "Tor Shutdown Hook"));
    }
}

