/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.network;

import lombok.Generated;

public final class IPv4 {
    public static int toInt(String ip) {
        char[] chars = ip.toCharArray();
        int ipInt = 0;
        int cur = 0;
        int shift = 3;
        for (char c : chars) {
            if (c == '.') {
                ipInt |= cur << 8 * shift;
                cur = 0;
                --shift;
                continue;
            }
            cur = cur * 10 + (c - 48);
        }
        return ipInt |= cur << 8 * shift;
    }

    public static String toString(int ip) {
        StringBuilder sb = new StringBuilder();
        for (int i = 3; i >= 0; --i) {
            sb.append(ip >> 8 * i & 0xFF);
            if (i <= 0) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public static int[] expandSubnet(String ipAndSubnet) {
        String[] parts = ipAndSubnet.split("/");
        String ip = parts[0];
        int subnet = Integer.parseInt(parts[1]);
        return IPv4.expandSubnet(IPv4.toInt(ip), subnet);
    }

    public static int[] expandSubnet(int ip, int subnet) {
        int subnetCount = 32 - subnet;
        int subnetMask = -1 << subnetCount;
        int[] addresses = new int[(int)Math.pow(2.0, subnetCount)];
        int maskedIP = ip & subnetMask;
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = maskedIP | i;
        }
        return addresses;
    }

    @Generated
    private IPv4() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

